"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.stopSync = exports.startSync = void 0;
const icalSync_1 = require("./icalSync");
const reviewSync_1 = require("./reviewSync");
const checkout_service_1 = __importDefault(require("../services/checkout.service"));
let syncInterval = null;
/**
 * Start the synchronization scheduler
 * @param intervalMinutes How often to sync (in minutes)
 */
const startSync = (intervalMinutes = 30) => {
    // Clear existing interval if it exists
    if (syncInterval) {
        clearInterval(syncInterval);
    }
    console.log(`Starting sync scheduler with interval of ${intervalMinutes} minutes`);
    // Run the sync immediately on startup
    Promise.all([
        (0, icalSync_1.syncExternalCalendars)()
            .then(() => console.log('Initial calendar sync completed successfully'))
            .catch((error) => console.error('Initial calendar sync failed:', error)),
        (0, reviewSync_1.syncExternalReviews)()
            .then(() => console.log('Initial review sync completed successfully'))
            .catch((error) => console.error('Initial review sync failed:', error)),
        checkout_service_1.default.completePastCheckouts()
            .then(() => checkout_service_1.default.processCheckoutFeedback())
            .then(() => console.log('Initial checkout and feedback processing completed successfully'))
            .catch((error) => console.error('Initial checkout and feedback processing failed:', error))
    ]).catch(error => console.error('Error during initial sync:', error));
    // Set up regular interval
    syncInterval = setInterval(() => {
        console.log('Running scheduled sync...');
        Promise.all([
            (0, icalSync_1.syncExternalCalendars)()
                .then(() => console.log('Scheduled calendar sync completed successfully'))
                .catch((error) => console.error('Scheduled calendar sync failed:', error)),
            (0, reviewSync_1.syncExternalReviews)()
                .then(() => console.log('Scheduled review sync completed successfully'))
                .catch((error) => console.error('Scheduled review sync failed:', error)),
            checkout_service_1.default.completePastCheckouts()
                .then(() => checkout_service_1.default.processCheckoutFeedback())
                .then(() => console.log('Scheduled checkout and feedback processing completed successfully'))
                .catch((error) => console.error('Scheduled checkout and feedback processing failed:', error))
        ]).catch(error => console.error('Error during scheduled sync:', error));
    }, intervalMinutes * 60 * 1000);
    return syncInterval;
};
exports.startSync = startSync;
/**
 * Stop the synchronization scheduler
 */
const stopSync = () => {
    if (syncInterval) {
        clearInterval(syncInterval);
        syncInterval = null;
        console.log('Sync scheduler stopped');
        return true;
    }
    return false;
};
exports.stopSync = stopSync;
