"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.runCleanupManually = exports.getCleanupSchedulerStatus = exports.stopCleanupScheduler = exports.startCleanupScheduler = void 0;
const cron = __importStar(require("node-cron"));
const cleanup_service_1 = __importDefault(require("../services/cleanup.service"));
const logger_1 = __importDefault(require("./logger"));
/**
 * Cleanup Scheduler
 * Schedules daily cleanup tasks to run at midnight
 */
let dailyCleanupJob = null;
let pendingBookingCleanupJob = null;
/**
 * Start the cleanup scheduler
 * Runs daily at midnight (00:00)
 */
const startCleanupScheduler = () => {
    if (dailyCleanupJob || pendingBookingCleanupJob) {
        logger_1.default.warn('Cleanup scheduler is already running');
        return;
    }
    // Schedule daily cleanup to run at midnight
    dailyCleanupJob = cron.schedule('0 0 * * *', () => __awaiter(void 0, void 0, void 0, function* () {
        try {
            logger_1.default.info('Running scheduled daily cleanup');
            yield cleanup_service_1.default.runDailyCleanup();
        }
        catch (error) {
            logger_1.default.error(`Scheduled daily cleanup failed: ${error.message}`, { error });
        }
    }), {
        timezone: 'UTC'
    });
    logger_1.default.info('Daily cleanup scheduler started - will run daily at midnight UTC');
    // Schedule pending booking cleanup to run every minute
    pendingBookingCleanupJob = cron.schedule('* * * * *', () => __awaiter(void 0, void 0, void 0, function* () {
        try {
            yield cleanup_service_1.default.cleanupPendingBookings();
        }
        catch (error) {
            // Errors are logged within the service, no need to re-log here
        }
    }));
    logger_1.default.info('Pending booking cleanup scheduler started - will run every minute');
};
exports.startCleanupScheduler = startCleanupScheduler;
/**
 * Stop the cleanup scheduler
 */
const stopCleanupScheduler = () => {
    let stopped = false;
    if (dailyCleanupJob) {
        dailyCleanupJob.stop();
        dailyCleanupJob = null;
        logger_1.default.info('Daily cleanup scheduler stopped');
        stopped = true;
    }
    if (pendingBookingCleanupJob) {
        pendingBookingCleanupJob.stop();
        pendingBookingCleanupJob = null;
        logger_1.default.info('Pending booking cleanup scheduler stopped');
        stopped = true;
    }
    if (!stopped) {
        logger_1.default.warn('Cleanup schedulers are not running');
    }
};
exports.stopCleanupScheduler = stopCleanupScheduler;
/**
 * Get cleanup scheduler status
 */
const getCleanupSchedulerStatus = () => {
    return {
        dailyCleanup: {
            isRunning: !!dailyCleanupJob,
            nextRun: dailyCleanupJob ? 'Daily at 00:00 UTC' : 'Not running'
        },
        pendingBookingCleanup: {
            isRunning: !!pendingBookingCleanupJob,
            interval: pendingBookingCleanupJob ? 'Every minute' : 'Not running'
        }
    };
};
exports.getCleanupSchedulerStatus = getCleanupSchedulerStatus;
/**
 * Run cleanup manually (for testing or manual triggers)
 */
const runCleanupManually = () => __awaiter(void 0, void 0, void 0, function* () {
    try {
        logger_1.default.info('Running manual cleanup');
        yield cleanup_service_1.default.runDailyCleanup();
    }
    catch (error) {
        logger_1.default.error(`Manual cleanup failed: ${error.message}`, { error });
        throw error;
    }
});
exports.runCleanupManually = runCleanupManually;
