"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const nodemailer_1 = __importDefault(require("nodemailer"));
const dotenv_1 = __importDefault(require("dotenv"));
dotenv_1.default.config();
class EmailService {
    constructor() {
        this.transporter = nodemailer_1.default.createTransport({
            host: process.env.EMAIL_HOST || 'smtp.gmail.com',
            port: parseInt(process.env.EMAIL_PORT || '587'),
            secure: process.env.EMAIL_SECURE === 'true', // true for 465, false for other ports
            auth: {
                user: process.env.EMAIL_USER,
                pass: process.env.EMAIL_PASS,
            },
        });
    }
    sendEmail(options) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const mailOptions = {
                    from: options.from || `"Casa Del Mar" <${process.env.EMAIL_FROM || process.env.EMAIL_USER}>`,
                    to: options.to,
                    subject: options.subject,
                    html: options.html,
                };
                yield this.transporter.sendMail(mailOptions);
                console.log(`Email sent successfully to ${options.to}`);
            }
            catch (error) {
                console.error('Error sending email:', error);
                throw new Error('Failed to send email');
            }
        });
    }
    sendContactNotification(name, email, subject, message, phone) {
        return __awaiter(this, void 0, void 0, function* () {
            const ownerEmail = process.env.OWNER_EMAIL || 'admin@casadelmar.com';
            const html = `
      <!DOCTYPE html>
      <html>
        <head>
          <style>
            body { font-family: Arial, sans-serif; color: #333; }
            .container { max-width: 600px; margin: 0 auto; padding: 20px; }
            .header { background-color: #2563eb; color: white; padding: 20px; text-align: center; }
            .content { background-color: #f9f9f9; padding: 20px; margin-top: 20px; }
            .message-box { background-color: white; padding: 15px; border-left: 3px solid #2563eb; margin-top: 10px; }
            .footer { text-align: center; margin-top: 20px; color: #666; font-size: 12px; }
          </style>
        </head>
        <body>
          <div class="container">
            <div class="header">
              <h1>New Contact Form Submission</h1>
            </div>
            <div class="content">
              <h2>Contact Details</h2>
              <p><strong>Name:</strong> ${name}</p>
              <p><strong>Email:</strong> <a href="mailto:${email}">${email}</a></p>
              ${phone ? `<p><strong>Phone:</strong> ${phone}</p>` : ''}
              <p><strong>Subject:</strong> ${subject}</p>
              
              <h3>Message:</h3>
              <div class="message-box">
                <p>${message.replace(/\n/g, '<br>')}</p>
              </div>
              
              <p style="margin-top: 20px;">
                <a href="${process.env.DASHBOARD_URL || 'http://localhost:5173'}/messages" 
                   style="background-color: #2563eb; color: white; padding: 10px 20px; text-decoration: none; border-radius: 5px;">
                  View in Dashboard
                </a>
              </p>
            </div>
            <div class="footer">
              <p>This is an automated email from Casa Del Mar contact form.</p>
            </div>
          </div>
        </body>
      </html>
    `;
            yield this.sendEmail({
                to: ownerEmail,
                subject: `New Contact Form: ${subject}`,
                html,
            });
        });
    }
    sendFeedbackRequest(guestEmail, guestName, roomName, checkInDate, checkOutDate, feedbackToken) {
        return __awaiter(this, void 0, void 0, function* () {
            const feedbackUrl = `${process.env.FRONTEND_URL || 'http://localhost:5174'}/feedback/${feedbackToken}`;
            const html = `
      <!DOCTYPE html>
      <html>
        <head>
          <style>
            body { font-family: Arial, sans-serif; color: #333; line-height: 1.6; }
            .container { max-width: 600px; margin: 0 auto; padding: 20px; }
            .header { background-color: #2563eb; color: white; padding: 30px 20px; text-align: center; border-radius: 8px 8px 0 0; }
            .content { background-color: #f9f9f9; padding: 30px 20px; border-radius: 0 0 8px 8px; }
            .booking-details { background-color: white; padding: 20px; border-left: 4px solid #2563eb; margin: 20px 0; border-radius: 4px; }
            .cta-button { 
              display: inline-block; 
              background-color: #2563eb; 
              color: white; 
              padding: 15px 30px; 
              text-decoration: none; 
              border-radius: 6px; 
              font-weight: bold; 
              margin: 20px 0;
              text-align: center;
            }
            .footer { text-align: center; margin-top: 30px; color: #666; font-size: 12px; }
            .rating-stars { font-size: 24px; color: #fbbf24; margin: 10px 0; }
          </style>
        </head>
        <body>
          <div class="container">
            <div class="header">
              <h1>Thank You for Staying with Us!</h1>
              <div class="rating-stars">⭐⭐⭐⭐⭐</div>
            </div>
            <div class="content">
              <p>Dear ${guestName},</p>
              
              <p>We hope you had a wonderful stay at Casa Del Mar! Your experience is incredibly important to us, and we would be grateful if you could share your feedback.</p>
              
              <div class="booking-details">
                <h3>Your Stay Details:</h3>
                <p><strong>Room:</strong> ${roomName}</p>
                <p><strong>Check-in:</strong> ${checkInDate}</p>
                <p><strong>Check-out:</strong> ${checkOutDate}</p>
              </div>
              
              <p>Your feedback helps us improve our services and assists future guests in making their decision. It will only take 2-3 minutes of your time.</p>
              
              <div style="text-align: center;">
                <a href="${feedbackUrl}" class="cta-button">Share Your Feedback</a>
              </div>
              
              <p>If the button doesn't work, you can also copy and paste this link into your browser:</p>
              <p style="word-break: break-all; background: #e5e7eb; padding: 10px; border-radius: 4px;">${feedbackUrl}</p>
              
              <p>Thank you once again for choosing Casa Del Mar. We look forward to welcoming you back in the future!</p>
              
              <p>Warm regards,<br>
              Casa Del Mar Team</p>
            </div>
            <div class="footer">
              <p>Casa Del Mar | Your comfort is our priority</p>
              <p>This feedback request was sent because you recently completed a stay with us.</p>
            </div>
          </div>
        </body>
      </html>
    `;
            yield this.sendEmail({
                to: guestEmail,
                subject: 'Share Your Experience at Casa Del Mar ⭐',
                html,
            });
        });
    }
    sendContactReply(guestEmail, guestName, replyMessage, originalSubject) {
        return __awaiter(this, void 0, void 0, function* () {
            const html = `
      <!DOCTYPE html>
      <html>
        <head>
          <style>
            body { font-family: Arial, sans-serif; color: #333; }
            .container { max-width: 600px; margin: 0 auto; padding: 20px; }
            .header { background-color: #2563eb; color: white; padding: 20px; text-align: center; }
            .content { padding: 20px; }
            .message-box { background-color: #f9f9f9; padding: 15px; border-left: 3px solid #2563eb; margin-top: 10px; }
            .footer { text-align: center; margin-top: 30px; color: #666; font-size: 12px; }
          </style>
        </head>
        <body>
          <div class="container">
            <div class="header">
              <h1>Casa Del Mar</h1>
            </div>
            <div class="content">
              <p>Dear ${guestName},</p>
              
              <p>Thank you for contacting us. We have received your message regarding "${originalSubject}" and are pleased to respond.</p>
              
              <h3>Our Response:</h3>
              <div class="message-box">
                <p>${replyMessage.replace(/\n/g, '<br>')}</p>
              </div>
              
              <p style="margin-top: 20px;">If you have any further questions, please don't hesitate to contact us again.</p>
              
              <p>Best regards,<br>
              Casa Del Mar Team</p>
            </div>
            <div class="footer">
              <p>Casa Del Mar | Your comfort is our priority</p>
              <p>This email was sent in response to your inquiry.</p>
            </div>
          </div>
        </body>
      </html>
    `;
            yield this.sendEmail({
                to: guestEmail,
                subject: `Re: ${originalSubject}`,
                html,
            });
        });
    }
}
exports.default = new EmailService();
