"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CouponService = void 0;
const sequelize_1 = require("sequelize");
const models_1 = __importDefault(require("../models"));
const models_2 = require("../models");
class CouponService {
    static createCoupon(couponData) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield models_1.default.Coupon.create(couponData);
        });
    }
    static getAllCoupons() {
        return __awaiter(this, void 0, void 0, function* () {
            return yield models_1.default.Coupon.findAll();
        });
    }
    static getCouponById(id) {
        return __awaiter(this, void 0, void 0, function* () {
            return yield models_1.default.Coupon.findByPk(id);
        });
    }
    static updateCoupon(id, updateData) {
        return __awaiter(this, void 0, void 0, function* () {
            const coupon = yield models_1.default.Coupon.findByPk(id);
            if (!coupon)
                return null;
            return yield coupon.update(updateData);
        });
    }
    static deleteCoupon(id) {
        return __awaiter(this, void 0, void 0, function* () {
            const coupon = yield models_1.default.Coupon.findByPk(id);
            if (!coupon)
                return false;
            yield coupon.destroy();
            return true;
        });
    }
    static validateCoupon(code, bookingAmount) {
        return __awaiter(this, void 0, void 0, function* () {
            const coupon = yield models_1.default.Coupon.findOne({
                where: {
                    code,
                    isActive: true,
                    startDate: { [sequelize_1.Op.lte]: new Date() },
                    endDate: { [sequelize_1.Op.gte]: new Date() },
                    usageCount: { [sequelize_1.Op.lt]: models_2.sequelize.col('usage_limit') }
                }
            });
            if (!coupon)
                return null;
            if (bookingAmount < coupon.minBookingAmount) {
                throw new Error(`Minimum booking amount of ${coupon.minBookingAmount} required for this coupon`);
            }
            const discountAmount = Math.min((bookingAmount * coupon.discountPercentage) / 100, coupon.maxDiscount);
            return {
                coupon,
                discountAmount
            };
        });
    }
    static applyCoupon(code, bookingAmount) {
        return __awaiter(this, void 0, void 0, function* () {
            const validation = yield this.validateCoupon(code, bookingAmount);
            if (!validation) {
                throw new Error('Invalid or expired coupon code');
            }
            const { coupon, discountAmount } = validation;
            yield coupon.increment('usageCount');
            return {
                discountAmount,
                finalAmount: bookingAmount - discountAmount,
                couponDetails: {
                    code: coupon.code,
                    discountPercentage: coupon.discountPercentage,
                    maxDiscount: coupon.maxDiscount
                }
            };
        });
    }
}
exports.CouponService = CouponService;
