"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const icalSync_1 = require("../utils/icalSync");
const models_1 = require("../models");
/**
 * Standalone script to sync all external calendars
 * Can be used in a cron job or scheduled task
 */
function syncAllCalendars() {
    return __awaiter(this, void 0, void 0, function* () {
        try {
            console.log('Starting calendar synchronization...');
            // Make sure database connection is established
            yield models_1.sequelize.authenticate();
            console.log('Database connection established successfully.');
            // Sync all calendars
            yield (0, icalSync_1.syncExternalCalendars)();
            console.log('Calendar synchronization completed successfully.');
            // Close the database connection
            yield models_1.sequelize.close();
            console.log('Database connection closed.');
            // Exit process with success
            process.exit(0);
        }
        catch (error) {
            console.error('Error syncing calendars:', error);
            // Close the database connection
            try {
                yield models_1.sequelize.close();
                console.log('Database connection closed.');
            }
            catch (err) {
                console.error('Error closing database connection:', err);
            }
            // Exit process with error
            process.exit(1);
        }
    });
}
// Execute the function
syncAllCalendars();
