"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const userAuth_controller_1 = require("../controllers/userAuth.controller");
const validate_middleware_1 = require("../middlewares/validate.middleware");
const validation_1 = require("../utils/validation");
const auth_middleware_1 = require("../middlewares/auth.middleware");
const router = (0, express_1.Router)();
router.post('/auth/login', (0, validate_middleware_1.validate)(validation_1.loginSchema), userAuth_controller_1.login);
// Protected routes for current user
router.use('/auth/me', auth_middleware_1.protect);
router.get('/auth/me', userAuth_controller_1.getCurrentUser);
router.patch('/auth/update-password/:id', (0, validate_middleware_1.validate)(validation_1.updatePasswordSchema), userAuth_controller_1.updatePassword);
router.use('/users', auth_middleware_1.protect);
router.use('/users', (0, auth_middleware_1.restrictTo)('admin', 'manager'));
router.route('/users')
    .get(userAuth_controller_1.getAllUsers)
    .post((0, validate_middleware_1.validate)(validation_1.userSchema), userAuth_controller_1.createUser);
router.route('/users/:id')
    .get(userAuth_controller_1.getUserById)
    .patch((0, validate_middleware_1.validate)(validation_1.updateUserSchema), userAuth_controller_1.updateUser)
    .delete(userAuth_controller_1.deleteUser);
exports.default = router;
