"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const room_controller_1 = require("../controllers/room.controller");
const review_controller_1 = require("../controllers/review.controller");
const index_1 = require("../utils/validation/index");
const validate_middleware_1 = require("../middlewares/validate.middleware");
const auth_middleware_1 = require("../middlewares/auth.middleware");
const calendar_controller_1 = require("../controllers/calendar.controller");
const router = express_1.default.Router();
// Public routes
router.get('/', room_controller_1.getAllRooms);
router.get('/availability', room_controller_1.checkRoomAvailability);
router.get('/:id', room_controller_1.getRoomById);
router.get('/:id/reviews', review_controller_1.getRoomReviews);
// Protected routes
router.use(auth_middleware_1.protect);
router.use((0, auth_middleware_1.restrictTo)('admin', 'staff'));
router.post('/', room_controller_1.uploadRoomImages, (0, validate_middleware_1.validate)(index_1.roomSchema), room_controller_1.createRoom);
router.patch('/:id', room_controller_1.deleteRoomImages, room_controller_1.uploadRoomImages, (0, validate_middleware_1.validate)(index_1.updateRoomSchema), room_controller_1.updateRoom);
router.delete('/:id', room_controller_1.deleteRoom);
// External Calendar Routes
router.get('/:roomId/calendars', calendar_controller_1.getExternalCalendars);
router.post('/:roomId/calendars', (0, validate_middleware_1.validate)(index_1.externalCalendarSchema), calendar_controller_1.addExternalCalendar);
router.put('/:roomId/calendars/:calendarId', (0, validate_middleware_1.validate)(index_1.updateExternalCalendarSchema), calendar_controller_1.updateExternalCalendar);
router.delete('/:roomId/calendars/:calendarId', calendar_controller_1.deleteExternalCalendar);
// Sync Routes
router.post('/:roomId/calendars/sync', calendar_controller_1.syncCalendars);
exports.default = router;
