"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const review_controller_1 = require("../controllers/review.controller");
// import { authenticateAdmin } from '../middlewares/auth.middleware';
// import { authenticateUser } from '../middlewares/auth.middleware';
const router = (0, express_1.Router)();
// Public routes (landing page)
router.get('/public', review_controller_1.getPublicReviews);
router.get('/room/:roomId', review_controller_1.getRoomReviews);
// Protected routes (dashboard)
// router.use(authenticateAdmin); // All routes below this require admin authentication
router.get('/', review_controller_1.getAllReviews);
router.get('/:id', review_controller_1.getReviewById);
router.put('/:id', review_controller_1.updateReview);
router.delete('/:id', review_controller_1.deleteReview);
// User authenticated routes
// router.post('/', authenticateUser, createReview);
exports.default = router;
