"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const paymentVerification_controller_1 = require("../controllers/paymentVerification.controller");
const router = (0, express_1.Router)();
/**
 * Payment verification routes - PUBLIC (no authentication required)
 * These routes are used by frontend payment pages to verify legitimate access
 */
// Verify payment access for frontend pages
router.get('/verify', paymentVerification_controller_1.verifyPaymentAccess);
// Get real-time payment status
router.get('/status/:payment_ref', paymentVerification_controller_1.getPaymentStatus);
exports.default = router;
