"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const payment_controller_1 = require("../controllers/payment.controller");
const validate_middleware_1 = require("../middlewares/validate.middleware");
const validation_1 = require("../utils/validation");
const auth_middleware_1 = require("../middlewares/auth.middleware");
const paymentWebhook_controller_1 = require("../controllers/paymentWebhook.controller");
const paymentRateLimit_middleware_1 = require("../middlewares/paymentRateLimit.middleware");
const router = (0, express_1.Router)();
// --- PUBLIC ROUTES ---
// Create a new payment intent
router.post('/', paymentRateLimit_middleware_1.paymentRateLimit, (0, validate_middleware_1.validate)(validation_1.paymentSchema), payment_controller_1.createPayment);
// Konnect webhook endpoint
router.post('/webhook', paymentWebhook_controller_1.processWebhook);
// Get payment status for the pending page polling
router.get('/status/:paymentRef', payment_controller_1.getPaymentStatusByRef);
// --- PROTECTED ROUTES ---
router.use(auth_middleware_1.protect);
// Get all payments (Admins only)
router.get('/', (0, auth_middleware_1.restrictTo)('admin'), payment_controller_1.getAllPayments);
// Get a single payment by ID (Admins only)
router.get('/:id', (0, auth_middleware_1.restrictTo)('admin'), payment_controller_1.getPaymentById);
// Manually update payment status (Admins only)
router.patch('/:id/status', (0, auth_middleware_1.restrictTo)('admin'), (0, validate_middleware_1.validate)(validation_1.updatePaymentStatusSchema), payment_controller_1.updatePaymentStatus);
// Delete a payment (Admins only)
router.delete('/:id', (0, auth_middleware_1.restrictTo)('admin'), payment_controller_1.deletePayment);
exports.default = router;
