"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = __importDefault(require("express"));
const auth_middleware_1 = require("../middlewares/auth.middleware");
const multiRoomCalendar_controller_1 = require("../controllers/multiRoomCalendar.controller");
const router = express_1.default.Router();
// Public route for exporting all rooms calendar
router.get('/export/all', multiRoomCalendar_controller_1.exportAllRoomsCalendar);
// Protect all routes
router.use(auth_middleware_1.protect);
router.use((0, auth_middleware_1.restrictTo)('admin', 'manager'));
// Multi-room calendar routes
router
    .route('/')
    .get(multiRoomCalendar_controller_1.getMultiRoomCalendars)
    .post(multiRoomCalendar_controller_1.createMultiRoomCalendar);
router
    .route('/:id')
    .get(multiRoomCalendar_controller_1.getMultiRoomCalendar)
    .put(multiRoomCalendar_controller_1.updateMultiRoomCalendar)
    .delete(multiRoomCalendar_controller_1.deleteMultiRoomCalendar);
// Preview calendar before creating
router.post('/preview', multiRoomCalendar_controller_1.previewMultiRoomCalendar);
// ICS file upload endpoints  
router.post('/preview-ics', multiRoomCalendar_controller_1.previewIcsFile);
router.post('/import-ics', multiRoomCalendar_controller_1.importIcsFile);
// Parse and import reservations
router.get('/:id/parse', multiRoomCalendar_controller_1.parseReservations);
router.post('/:id/import', multiRoomCalendar_controller_1.importReservations);
// Get guest info for specific reservation UID
router.get('/:id/reservations/:uid/guest-info', multiRoomCalendar_controller_1.getReservationGuestInfo);
// Room mapping routes for calendars
router
    .route('/:id/mappings')
    .get(multiRoomCalendar_controller_1.getRoomMappings)
    .post(multiRoomCalendar_controller_1.createRoomMapping);
router
    .route('/:calendarId/mappings/:mappingId')
    .put(multiRoomCalendar_controller_1.updateRoomMapping)
    .delete(multiRoomCalendar_controller_1.deleteRoomMapping);
// Room-specific mapping routes (for room pages)
router.get('/rooms/:roomId/mappings', multiRoomCalendar_controller_1.getRoomMappingsForRoom);
router.post('/rooms/:roomId/mappings', multiRoomCalendar_controller_1.createRoomMappingFromRoom);
// Guest detail extraction routes
router.post('/extract-guest-details', multiRoomCalendar_controller_1.extractGuestDetails);
router.post('/extract-guest-details/summary', multiRoomCalendar_controller_1.extractGuestDetailsFromEventSummary);
// Export calendar for a specific room
router.get('/export/:roomId', multiRoomCalendar_controller_1.exportRoomCalendar);
exports.default = router;
