"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const payment_controller_1 = require("../controllers/payment.controller");
const validate_middleware_1 = require("../middlewares/validate.middleware");
const validation_1 = require("../utils/validation");
const auth_middleware_1 = require("../middlewares/auth.middleware");
const router = (0, express_1.Router)();
// Protected: Admins and Managers can register manual (in-person/offline) payments
router.use(auth_middleware_1.protect);
router.use((0, auth_middleware_1.restrictTo)('admin', 'manager'));
router.post('/', (0, validate_middleware_1.validate)(validation_1.manualPaymentSchema), payment_controller_1.createManualPayment);
exports.default = router;
