"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const userAuth_routes_1 = __importDefault(require("./userAuth.routes"));
const room_routes_1 = __importDefault(require("./room.routes"));
const booking_routes_1 = __importDefault(require("./booking.routes"));
const payment_routes_1 = __importDefault(require("./payment.routes"));
const manualPayment_routes_1 = __importDefault(require("./manualPayment.routes"));
const paymentVerification_routes_1 = __importDefault(require("./paymentVerification.routes"));
const paymentWebhook_routes_1 = __importDefault(require("./paymentWebhook.routes"));
const contact_routes_1 = __importDefault(require("./contact.routes"));
const coupon_routes_1 = __importDefault(require("./coupon.routes"));
const review_routes_1 = __importDefault(require("./review.routes"));
const feedback_routes_1 = __importDefault(require("./feedback.routes"));
const checkout_routes_1 = __importDefault(require("./checkout.routes"));
const multiRoomCalendar_routes_1 = __importDefault(require("./multiRoomCalendar.routes"));
const calendar_routes_1 = __importDefault(require("./calendar.routes"));
const guest_routes_1 = __importDefault(require("./guest.routes"));
const amenity_routes_1 = __importDefault(require("./amenity.routes"));
const bookingRule_routes_1 = __importDefault(require("./bookingRule.routes"));
const dashboard_routes_1 = __importDefault(require("./dashboard.routes"));
const router = (0, express_1.Router)();
// Add logging middleware for all API routes
router.use((req, res, next) => {
    console.log('🌍 [API ROUTES] Incoming request:', {
        method: req.method,
        originalUrl: req.originalUrl,
        path: req.path,
        baseUrl: req.baseUrl,
        timestamp: new Date().toISOString()
    });
    next();
});
// Public routes (landing page)
router.use('/rooms', room_routes_1.default);
router.use('/bookings', booking_routes_1.default);
router.use('/payments', payment_routes_1.default);
router.use('/booking-rules', bookingRule_routes_1.default);
router.use('/manual-payments', manualPayment_routes_1.default);
router.use('/contacts', contact_routes_1.default);
router.use('/coupons', coupon_routes_1.default);
router.use('/reviews', review_routes_1.default);
router.use('/feedback', feedback_routes_1.default);
router.use('/checkout', checkout_routes_1.default);
router.use('/multi-room-calendars', multiRoomCalendar_routes_1.default);
router.use('/calendar', calendar_routes_1.default);
router.use('/guests', guest_routes_1.default);
router.use('/amenities', amenity_routes_1.default);
router.use('/dashboard', dashboard_routes_1.default);
router.use('/payment-webhook', paymentWebhook_routes_1.default);
router.use('/payment-verification', paymentVerification_routes_1.default);
// User and Auth routes
router.use('/', userAuth_routes_1.default);
exports.default = router;
