"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const guest_controller_1 = require("../controllers/guest.controller");
const validate_middleware_1 = require("../middlewares/validate.middleware");
const validation_1 = require("../utils/validation");
const auth_middleware_1 = require("../middlewares/auth.middleware");
const router = (0, express_1.Router)();
// Public route - anyone can create a guest
router.post('/', (0, validate_middleware_1.validate)(validation_1.guestSchema), guest_controller_1.createGuest);
// Protected routes - only admin and manager can access
router.use(auth_middleware_1.protect);
router.use((0, auth_middleware_1.restrictTo)('admin', 'manager'));
router.get('/', guest_controller_1.getAllGuests);
router.get('/:id', guest_controller_1.getGuestById);
router.patch('/:id', (0, validate_middleware_1.validate)(validation_1.updateGuestSchema), guest_controller_1.updateGuest);
router.delete('/:id', guest_controller_1.deleteGuest);
exports.default = router;
