"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const feedback_controller_1 = require("../controllers/feedback.controller");
const auth_middleware_1 = require("../middlewares/auth.middleware");
const router = (0, express_1.Router)();
// Public routes (guest feedback submission only)
router.get('/:token', feedback_controller_1.getFeedbackForm);
router.post('/:token', feedback_controller_1.submitFeedback);
// Protected routes (admin/manager only)
router.use(auth_middleware_1.protect);
router.use((0, auth_middleware_1.restrictTo)('admin', 'manager'));
router.get('/', feedback_controller_1.getAllFeedback);
router.get('/public', feedback_controller_1.getPublishedFeedback); // Dashboard viewing of published feedback
router.patch('/:id', feedback_controller_1.updateFeedback);
exports.default = router;
