"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const coupon_controller_1 = require("../controllers/coupon.controller");
const auth_middleware_1 = require("../middlewares/auth.middleware");
const validate_middleware_1 = require("../middlewares/validate.middleware");
const validation_1 = require("../utils/validation");
const router = (0, express_1.Router)();
// Public routes (landing page)
router.post('/validate', (0, validate_middleware_1.validate)(validation_1.validateCouponSchema), coupon_controller_1.validateCoupon);
router.post('/apply', (0, validate_middleware_1.validate)(validation_1.applyCouponSchema), coupon_controller_1.applyCoupon);
// Protected routes (dashboard)
router.use(auth_middleware_1.protect);
router.use((0, auth_middleware_1.restrictTo)('admin'));
router.post('/', (0, validate_middleware_1.validate)(validation_1.couponSchema), coupon_controller_1.createCoupon);
router.get('/', coupon_controller_1.getAllCoupons);
router.get('/:id', coupon_controller_1.getCouponById);
router.put('/:id', (0, validate_middleware_1.validate)(validation_1.updateCouponSchema), coupon_controller_1.updateCoupon);
router.delete('/:id', coupon_controller_1.deleteCoupon);
exports.default = router;
