"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const contact_controller_1 = require("../controllers/contact.controller");
const validate_middleware_1 = require("../middlewares/validate.middleware");
const validation_1 = require("../utils/validation");
const auth_middleware_1 = require("../middlewares/auth.middleware");
const router = (0, express_1.Router)();
// Public route for creating contact messages
router.post('/', (0, validate_middleware_1.validate)(validation_1.contactMessageSchema), contact_controller_1.createContactMessage);
// Protected routes
router.use(auth_middleware_1.protect);
// Routes accessible by all authenticated users
router.get('/', contact_controller_1.getAllContactMessages);
router.get('/:id', contact_controller_1.getContactMessageById);
router.patch('/:id', (0, validate_middleware_1.validate)(validation_1.updateContactMessageSchema), contact_controller_1.updateContactMessage);
router.post('/:id/reply', (0, validate_middleware_1.validate)(validation_1.replyContactMessageSchema), contact_controller_1.replyToContactMessage);
// Admin only can delete contact messages
router.delete('/:id', (0, auth_middleware_1.restrictTo)('admin'), contact_controller_1.deleteContactMessage);
exports.default = router;
