"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const checkout_controller_1 = require("../controllers/checkout.controller");
const auth_middleware_1 = require("../middlewares/auth.middleware");
const router = (0, express_1.Router)();
// All checkout routes require authentication
router.use(auth_middleware_1.protect);
/**
 * @route   POST /api/checkout/process-feedback
 * @desc    Manually trigger checkout feedback processing
 * @access  Private (Admin only)
 */
router.post('/process-feedback', checkout_controller_1.processCheckoutFeedback);
/**
 * @route   GET /api/checkout/feedback-stats
 * @desc    Get checkout feedback statistics
 * @access  Private
 * @query   days - Number of days to look back (default: 7)
 */
router.get('/feedback-stats', checkout_controller_1.getCheckoutFeedbackStats);
/**
 * @route   GET /api/checkout/status
 * @desc    Get checkout feedback processing status
 * @access  Private
 */
router.get('/status', checkout_controller_1.getCheckoutStatus);
exports.default = router;
