"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const calendar_controller_1 = require("../controllers/calendar.controller");
// import { authenticateAdmin } from '../middlewares/auth.middleware';
const router = (0, express_1.Router)();
// Public routes (landing page)
router.get('/availability', calendar_controller_1.getAvailability);
router.get('/room/:roomId/availability', calendar_controller_1.getRoomAvailability);
// Protected routes (dashboard)
// router.use(authenticateAdmin); // All routes below this require admin authentication
router.put('/availability', calendar_controller_1.updateAvailability);
// router.put('/:id/availability', auth, validate(updateAvailabilitySchema), updateAvailability);
// Calendar Synchronization
router.post('/sync', calendar_controller_1.syncExternalCalendar);
router.get('/external/events', calendar_controller_1.getExternalCalendarEvents);
router.put('/external/settings', calendar_controller_1.updateExternalCalendarSettings);
router.get('/:calendarId/preview', calendar_controller_1.previewExternalCalendar);
router.post('/import', calendar_controller_1.importFromExternalCalendar);
router.post('/preview-ics', calendar_controller_1.previewIcsFile);
exports.default = router;
