"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const bookingRule_controller_1 = require("../controllers/bookingRule.controller");
const auth_middleware_1 = require("../middlewares/auth.middleware");
const validate_middleware_1 = require("../middlewares/validate.middleware");
const validation_1 = require("../utils/validation");
const router = (0, express_1.Router)();
router.use(auth_middleware_1.protect);
router.use((0, auth_middleware_1.restrictTo)('admin', 'manager'));
router.get('/', bookingRule_controller_1.getBookingRules);
router.put('/', (0, validate_middleware_1.validate)(validation_1.bookingRulesSchema), bookingRule_controller_1.upsertBookingRules);
exports.default = router;
