"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const booking_controller_1 = require("../controllers/booking.controller");
const validate_middleware_1 = require("../middlewares/validate.middleware");
const validation_1 = require("../utils/validation");
const auth_middleware_1 = require("../middlewares/auth.middleware");
const bookingRateLimit_middleware_1 = require("../middlewares/bookingRateLimit.middleware");
const router = (0, express_1.Router)();
// Routes accessible by all authenticated users
router.get('/', auth_middleware_1.protect, booking_controller_1.getAllBookings);
router.get('/:id', auth_middleware_1.protect, booking_controller_1.getBookingById);
router.post('/', bookingRateLimit_middleware_1.bookingRateLimit, (0, validate_middleware_1.validate)(validation_1.bookingSchema), booking_controller_1.createBooking);
router.patch('/:id', auth_middleware_1.protect, (0, validate_middleware_1.validate)(validation_1.updateBookingSchema), booking_controller_1.updateBooking);
// Admin only can delete bookings
router.delete('/:id', auth_middleware_1.protect, (0, auth_middleware_1.restrictTo)('admin'), booking_controller_1.deleteBooking);
exports.default = router;
