"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const express_1 = require("express");
const amenity_controller_1 = require("../controllers/amenity.controller");
const validate_middleware_1 = require("../middlewares/validate.middleware");
const validation_1 = require("../utils/validation");
const auth_middleware_1 = require("../middlewares/auth.middleware");
const router = (0, express_1.Router)();
// Public routes
router.get('/', amenity_controller_1.getAllAmenities);
router.get('/:id', amenity_controller_1.getAmenityById);
// Room amenities routes
router.get('/room/:roomId', amenity_controller_1.getRoomAmenities);
// Protected routes - only admin can modify amenities
router.use(auth_middleware_1.protect);
router.use((0, auth_middleware_1.restrictTo)('admin'));
router.post('/', (0, validate_middleware_1.validate)(validation_1.amenitySchema), amenity_controller_1.createAmenity);
router.patch('/:id', (0, validate_middleware_1.validate)(validation_1.updateAmenitySchema), amenity_controller_1.updateAmenity);
router.delete('/:id', amenity_controller_1.deleteAmenity);
// Room-amenity relationship routes
router.post('/room/:roomId/amenity/:amenityId', amenity_controller_1.addAmenityToRoom);
router.delete('/room/:roomId/amenity/:amenityId', amenity_controller_1.removeAmenityFromRoom);
exports.default = router;
