"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const sequelize_1 = require("sequelize");
const passwordUtils_1 = require("../utils/passwordUtils");
exports.default = (sequelize) => {
    const User = sequelize.define('User', {
        id: {
            type: sequelize_1.DataTypes.INTEGER,
            autoIncrement: true,
            primaryKey: true,
        },
        firstName: {
            type: sequelize_1.DataTypes.STRING(50),
            allowNull: false,
            field: 'first_name',
        },
        lastName: {
            type: sequelize_1.DataTypes.STRING(50),
            allowNull: false,
            field: 'last_name',
        },
        email: {
            type: sequelize_1.DataTypes.STRING(100),
            allowNull: false,
            unique: true,
            validate: {
                isEmail: true,
            },
        },
        password: {
            type: sequelize_1.DataTypes.STRING(255),
            allowNull: false,
            validate: {
                len: [6, 255],
            },
        },
        role: {
            type: sequelize_1.DataTypes.ENUM('admin', 'manager', 'staff'),
            allowNull: false,
            defaultValue: 'staff',
        },
        createdAt: {
            type: sequelize_1.DataTypes.DATE,
            field: 'created_at',
        },
        updatedAt: {
            type: sequelize_1.DataTypes.DATE,
            field: 'updated_at',
        },
    }, {
        tableName: 'users',
        timestamps: true,
        hooks: {
            beforeCreate: (user) => __awaiter(void 0, void 0, void 0, function* () {
                if (user.password) {
                    user.password = yield (0, passwordUtils_1.hashPassword)(user.password);
                }
            }),
            beforeUpdate: (user) => __awaiter(void 0, void 0, void 0, function* () {
                if (user.changed('password')) {
                    user.password = yield (0, passwordUtils_1.hashPassword)(user.password);
                }
            }),
        },
    });
    // Fix the comparePassword method with appropriate typing
    User.prototype.comparePassword = function (password) {
        return __awaiter(this, void 0, void 0, function* () {
            return (0, passwordUtils_1.comparePassword)(password, this.password);
        });
    };
    // Define associations
    User.associate = (models) => {
        User.hasMany(models.Booking, { foreignKey: 'createdBy', as: 'bookings' });
        User.hasMany(models.ContactMessage, { foreignKey: 'assignedTo', as: 'assignedMessages' });
    };
    return User;
};
