"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sequelize_1 = require("sequelize");
exports.default = (sequelize) => {
    const RoomType = sequelize.define('RoomType', {
        id: {
            type: sequelize_1.DataTypes.INTEGER,
            autoIncrement: true,
            primaryKey: true,
        },
        name: {
            type: sequelize_1.DataTypes.STRING(50),
            allowNull: false,
            unique: true,
        },
        description: {
            type: sequelize_1.DataTypes.TEXT,
            allowNull: true,
        },
        basePrice: {
            type: sequelize_1.DataTypes.DECIMAL(10, 2),
            allowNull: false,
            field: 'base_price',
        },
        createdAt: {
            type: sequelize_1.DataTypes.DATE,
            field: 'created_at',
        },
        updatedAt: {
            type: sequelize_1.DataTypes.DATE,
            field: 'updated_at',
        },
    }, {
        tableName: 'room_types',
        timestamps: true,
    });
    // Define associations
    RoomType.associate = (models) => {
        RoomType.hasMany(models.Room, { foreignKey: 'roomTypeId', as: 'rooms' });
    };
    return RoomType;
};
