"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sequelize_1 = require("sequelize");
exports.default = (sequelize) => {
    const RoomAvailability = sequelize.define('RoomAvailability', {
        id: {
            type: sequelize_1.DataTypes.INTEGER,
            autoIncrement: true,
            primaryKey: true,
        },
        roomId: {
            type: sequelize_1.DataTypes.INTEGER,
            allowNull: false,
            field: 'room_id',
            references: {
                model: 'rooms',
                key: 'id',
            },
        },
        date: {
            type: sequelize_1.DataTypes.DATEONLY,
            allowNull: false,
        },
        isAvailable: {
            type: sequelize_1.DataTypes.BOOLEAN,
            allowNull: false,
            defaultValue: true,
            field: 'is_available',
        },
        bookingId: {
            type: sequelize_1.DataTypes.INTEGER,
            allowNull: true,
            field: 'booking_id',
            references: {
                model: 'bookings',
                key: 'id',
            },
        },
        createdAt: {
            type: sequelize_1.DataTypes.DATE,
            field: 'created_at',
        },
        updatedAt: {
            type: sequelize_1.DataTypes.DATE,
            field: 'updated_at',
        },
    }, {
        tableName: 'room_availability',
        timestamps: true,
        indexes: [
            {
                unique: true,
                fields: ['room_id', 'date'],
            },
        ],
    });
    // Define associations
    RoomAvailability.associate = (models) => {
        RoomAvailability.belongsTo(models.Room, { foreignKey: 'roomId', as: 'room' });
        RoomAvailability.belongsTo(models.Booking, { foreignKey: 'bookingId', as: 'booking' });
    };
    return RoomAvailability;
};
