"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sequelize_1 = require("sequelize");
exports.default = (sequelize) => {
    const RoomAmenity = sequelize.define('RoomAmenity', {
        roomId: {
            type: sequelize_1.DataTypes.INTEGER,
            allowNull: false,
            primaryKey: true,
            field: 'room_id',
            references: {
                model: 'rooms',
                key: 'id'
            }
        },
        amenityId: {
            type: sequelize_1.DataTypes.INTEGER,
            allowNull: false,
            primaryKey: true,
            field: 'amenity_id',
            references: {
                model: 'amenities',
                key: 'id'
            }
        },
        createdAt: {
            type: sequelize_1.DataTypes.DATE,
            field: 'created_at',
        },
        updatedAt: {
            type: sequelize_1.DataTypes.DATE,
            field: 'updated_at',
        },
    }, {
        tableName: 'room_amenities',
        timestamps: true,
    });
    return RoomAmenity;
};
