"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sequelize_1 = require("sequelize");
exports.default = (sequelize) => {
    const Review = sequelize.define('Review', {
        id: {
            type: sequelize_1.DataTypes.INTEGER,
            autoIncrement: true,
            primaryKey: true,
        },
        roomId: {
            type: sequelize_1.DataTypes.INTEGER,
            allowNull: false,
            field: 'room_id',
            references: {
                model: 'rooms',
                key: 'id',
            },
        },
        guestId: {
            type: sequelize_1.DataTypes.INTEGER,
            allowNull: false,
            field: 'guest_id',
            references: {
                model: 'guests',
                key: 'id',
            },
        },
        rating: {
            type: sequelize_1.DataTypes.INTEGER,
            allowNull: false,
            validate: {
                min: 1,
                max: 5,
            },
        },
        comment: {
            type: sequelize_1.DataTypes.TEXT,
            allowNull: false,
        },
        reviewDate: {
            type: sequelize_1.DataTypes.DATE,
            allowNull: false,
            defaultValue: sequelize_1.DataTypes.NOW,
            field: 'review_date',
        },
        isPublished: {
            type: sequelize_1.DataTypes.BOOLEAN,
            allowNull: false,
            defaultValue: true,
            field: 'is_published',
        },
        createdAt: {
            type: sequelize_1.DataTypes.DATE,
            field: 'created_at',
        },
        updatedAt: {
            type: sequelize_1.DataTypes.DATE,
            field: 'updated_at',
        },
    }, {
        tableName: 'reviews',
        timestamps: true,
    });
    // Define associations
    Review.associate = (models) => {
        Review.belongsTo(models.Room, { foreignKey: 'roomId', as: 'room' });
        Review.belongsTo(models.Guest, { foreignKey: 'guestId', as: 'guest' });
    };
    return Review;
};
