"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sequelize_1 = require("sequelize");
exports.default = (sequelize) => {
    const PaymentAttempt = sequelize.define('PaymentAttempt', {
        id: {
            type: sequelize_1.DataTypes.INTEGER,
            autoIncrement: true,
            primaryKey: true,
        },
        ipAddress: {
            type: sequelize_1.DataTypes.STRING(45), // Supports both IPv4 and IPv6
            allowNull: false,
            field: 'ip_address',
        },
        isSuccessful: {
            type: sequelize_1.DataTypes.BOOLEAN,
            allowNull: false,
            defaultValue: false,
            field: 'is_successful',
        },
        attemptedAt: {
            type: sequelize_1.DataTypes.DATE,
            allowNull: false,
            defaultValue: sequelize_1.DataTypes.NOW,
            field: 'attempted_at',
        },
        paymentId: {
            type: sequelize_1.DataTypes.INTEGER,
            allowNull: true,
            field: 'payment_id',
        },
        userAgent: {
            type: sequelize_1.DataTypes.TEXT,
            allowNull: true,
            field: 'user_agent',
        },
        createdAt: {
            type: sequelize_1.DataTypes.DATE,
            allowNull: false,
            defaultValue: sequelize_1.DataTypes.NOW,
            field: 'created_at',
        },
        updatedAt: {
            type: sequelize_1.DataTypes.DATE,
            allowNull: false,
            defaultValue: sequelize_1.DataTypes.NOW,
            field: 'updated_at',
        },
    }, {
        tableName: 'payment_attempts',
        timestamps: true,
        underscored: true,
        indexes: [
            {
                fields: ['ip_address'],
            },
            {
                fields: ['attempted_at'],
            },
            {
                fields: ['ip_address', 'attempted_at'],
            },
            {
                fields: ['is_successful'],
            },
        ],
    });
    // Define associations
    PaymentAttempt.associate = (models) => {
        PaymentAttempt.belongsTo(models.Payment, {
            foreignKey: 'paymentId',
            as: 'payment',
        });
    };
    return PaymentAttempt;
};
