"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sequelize_1 = require("sequelize");
exports.default = (sequelize) => {
    const Payment = sequelize.define('Payment', {
        id: {
            type: sequelize_1.DataTypes.INTEGER,
            autoIncrement: true,
            primaryKey: true,
        },
        bookingId: {
            type: sequelize_1.DataTypes.INTEGER,
            allowNull: false,
            field: 'booking_id',
            references: {
                model: 'bookings',
                key: 'id',
            },
        },
        amount: {
            type: sequelize_1.DataTypes.DECIMAL(10, 2),
            allowNull: false,
        },
        paymentDate: {
            type: sequelize_1.DataTypes.DATE,
            allowNull: false,
            defaultValue: sequelize_1.DataTypes.NOW,
            field: 'payment_date',
        },
        paymentMethod: {
            type: sequelize_1.DataTypes.ENUM('cash', 'credit_card', 'debit_card', 'bank_transfer', 'online', 'wallet', 'e-DINAR'),
            allowNull: false,
            field: 'payment_method',
        },
        status: {
            type: sequelize_1.DataTypes.ENUM('pending', 'completed', 'failed', 'refunded'),
            allowNull: false,
            defaultValue: 'pending',
        },
        transactionId: {
            type: sequelize_1.DataTypes.STRING(100),
            allowNull: true,
            field: 'transaction_id',
        },
        paymentUrl: {
            type: sequelize_1.DataTypes.STRING(255),
            allowNull: true,
            field: 'payment_url',
        },
        notes: {
            type: sequelize_1.DataTypes.TEXT,
            allowNull: true,
        },
        createdAt: {
            type: sequelize_1.DataTypes.DATE,
            field: 'created_at',
        },
        updatedAt: {
            type: sequelize_1.DataTypes.DATE,
            field: 'updated_at',
        },
    }, {
        tableName: 'payments',
        timestamps: true,
    });
    // Define associations
    Payment.associate = (models) => {
        Payment.belongsTo(models.Booking, { foreignKey: 'bookingId', as: 'booking' });
    };
    return Payment;
};
