"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sequelize_1 = require("sequelize");
exports.default = (sequelize) => {
    const MultiRoomCalendar = sequelize.define('MultiRoomCalendar', {
        id: {
            type: sequelize_1.DataTypes.INTEGER,
            autoIncrement: true,
            primaryKey: true,
        },
        name: {
            type: sequelize_1.DataTypes.STRING(100),
            allowNull: false,
        },
        source: {
            type: sequelize_1.DataTypes.STRING(50),
            allowNull: false,
            comment: 'Platform name (Airbnb, Booking.com, etc.)',
        },
        calendarUrl: {
            type: sequelize_1.DataTypes.TEXT,
            allowNull: false,
            field: 'calendar_url',
            comment: 'iCal URL for the multi-room calendar',
        },
        isActive: {
            type: sequelize_1.DataTypes.BOOLEAN,
            allowNull: false,
            defaultValue: true,
            field: 'is_active',
        },
        lastSynced: {
            type: sequelize_1.DataTypes.DATE,
            allowNull: true,
            field: 'last_synced',
        },
        syncSettings: {
            type: sequelize_1.DataTypes.JSON,
            allowNull: true,
            field: 'sync_settings',
            comment: 'Platform-specific sync settings',
        },
        createdAt: {
            type: sequelize_1.DataTypes.DATE,
            field: 'created_at',
        },
        updatedAt: {
            type: sequelize_1.DataTypes.DATE,
            field: 'updated_at',
        },
    }, {
        tableName: 'multi_room_calendars',
        timestamps: true,
        indexes: [
            {
                fields: ['source'],
            },
            {
                fields: ['is_active'],
            },
        ],
    });
    // Define associations
    MultiRoomCalendar.associate = (models) => {
        MultiRoomCalendar.hasMany(models.ExternalCalendar, {
            foreignKey: 'multiRoomCalendarId',
            as: 'roomMappings'
        });
    };
    return MultiRoomCalendar;
};
