"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.sequelize = void 0;
const sequelize_1 = require("sequelize");
const app_1 = __importDefault(require("../config/app"));
const database_1 = __importDefault(require("../config/database"));
// Import models here
const user_1 = __importDefault(require("./user"));
const roomType_1 = __importDefault(require("./roomType"));
const room_1 = __importDefault(require("./room"));
const guest_1 = __importDefault(require("./guest"));
const booking_1 = __importDefault(require("./booking"));
const payment_1 = __importDefault(require("./payment"));
const paymentAttempt_model_1 = __importDefault(require("./paymentAttempt.model"));
const bookingAttempt_model_1 = __importDefault(require("./bookingAttempt.model"));
const paymentAccessToken_model_1 = __importDefault(require("./paymentAccessToken.model"));
const contactMessage_1 = __importDefault(require("./contactMessage"));
const externalCalendar_1 = __importDefault(require("./externalCalendar"));
const coupon_model_1 = __importDefault(require("./coupon.model"));
const review_1 = __importDefault(require("./review"));
const amenity_model_1 = __importDefault(require("./amenity.model"));
const roomAmenity_model_1 = __importDefault(require("./roomAmenity.model"));
const feedback_1 = __importDefault(require("./feedback"));
const feedbackToken_1 = __importDefault(require("./feedbackToken"));
const multiRoomCalendar_1 = __importDefault(require("./multiRoomCalendar"));
const bookingRule_1 = __importDefault(require("./bookingRule"));
// Get database config based on environment
const dbConfig = database_1.default[app_1.default.env];
// Initialize Sequelize with database configuration
const sequelize = new sequelize_1.Sequelize(dbConfig.database, dbConfig.username, dbConfig.password, {
    host: dbConfig.host,
    port: dbConfig.port,
    dialect: dbConfig.dialect,
    logging: dbConfig.logging,
    pool: dbConfig.pool || {
        max: 5,
        min: 0,
        acquire: 30000,
        idle: 10000,
    },
});
exports.sequelize = sequelize;
// Initialize models
const models = {
    User: (0, user_1.default)(sequelize),
    RoomType: (0, roomType_1.default)(sequelize),
    Room: (0, room_1.default)(sequelize),
    Guest: (0, guest_1.default)(sequelize),
    Booking: (0, booking_1.default)(sequelize),
    Payment: (0, payment_1.default)(sequelize),
    PaymentAttempt: (0, paymentAttempt_model_1.default)(sequelize),
    BookingAttempt: (0, bookingAttempt_model_1.default)(sequelize),
    PaymentAccessToken: (0, paymentAccessToken_model_1.default)(sequelize),
    ContactMessage: (0, contactMessage_1.default)(sequelize),
    ExternalCalendar: (0, externalCalendar_1.default)(sequelize),
    Coupon: (0, coupon_model_1.default)(sequelize),
    Review: (0, review_1.default)(sequelize),
    Amenity: (0, amenity_model_1.default)(sequelize),
    RoomAmenity: (0, roomAmenity_model_1.default)(sequelize),
    Feedback: (0, feedback_1.default)(sequelize),
    FeedbackToken: (0, feedbackToken_1.default)(sequelize),
    MultiRoomCalendar: (0, multiRoomCalendar_1.default)(sequelize),
    BookingRule: (0, bookingRule_1.default)(sequelize),
};
// Define associations
Object.keys(models).forEach((modelName) => {
    if (models[modelName].associate) {
        models[modelName].associate(models);
    }
});
exports.default = models;
