"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sequelize_1 = require("sequelize");
exports.default = (sequelize) => {
    const Guest = sequelize.define('Guest', {
        id: {
            type: sequelize_1.DataTypes.INTEGER,
            autoIncrement: true,
            primaryKey: true,
        },
        firstName: {
            type: sequelize_1.DataTypes.STRING(50),
            allowNull: false,
            field: 'first_name',
        },
        lastName: {
            type: sequelize_1.DataTypes.STRING(50),
            allowNull: false,
            field: 'last_name',
        },
        email: {
            type: sequelize_1.DataTypes.STRING(100),
            allowNull: false,
            validate: {
                isEmail: true,
            },
        },
        phone: {
            type: sequelize_1.DataTypes.STRING(20),
            allowNull: false,
        },
        address: {
            type: sequelize_1.DataTypes.TEXT,
            allowNull: true,
        },
        city: {
            type: sequelize_1.DataTypes.STRING(100),
            allowNull: true,
        },
        state: {
            type: sequelize_1.DataTypes.STRING(100),
            allowNull: true,
        },
        country: {
            type: sequelize_1.DataTypes.STRING(100),
            allowNull: true,
        },
        postalCode: {
            type: sequelize_1.DataTypes.STRING(20),
            allowNull: true,
            field: 'postal_code',
        },
        createdAt: {
            type: sequelize_1.DataTypes.DATE,
            field: 'created_at',
        },
        updatedAt: {
            type: sequelize_1.DataTypes.DATE,
            field: 'updated_at',
        },
    }, {
        tableName: 'guests',
        timestamps: true,
    });
    // Define associations
    Guest.associate = (models) => {
        Guest.hasMany(models.Booking, { foreignKey: 'guestId', as: 'bookings' });
    };
    return Guest;
};
