"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sequelize_1 = require("sequelize");
exports.default = (sequelize) => {
    const FeedbackToken = sequelize.define('FeedbackToken', {
        id: {
            type: sequelize_1.DataTypes.INTEGER,
            autoIncrement: true,
            primaryKey: true,
        },
        token: {
            type: sequelize_1.DataTypes.STRING(64),
            allowNull: false,
            unique: true,
            field: 'token',
        },
        bookingId: {
            type: sequelize_1.DataTypes.INTEGER,
            allowNull: false,
            field: 'booking_id',
            references: {
                model: 'bookings',
                key: 'id',
            },
        },
        guestId: {
            type: sequelize_1.DataTypes.INTEGER,
            allowNull: false,
            field: 'guest_id',
            references: {
                model: 'guests',
                key: 'id',
            },
        },
        expiresAt: {
            type: sequelize_1.DataTypes.DATE,
            allowNull: false,
            field: 'expires_at',
        },
        isUsed: {
            type: sequelize_1.DataTypes.BOOLEAN,
            allowNull: false,
            defaultValue: false,
            field: 'is_used',
        },
        usedAt: {
            type: sequelize_1.DataTypes.DATE,
            allowNull: true,
            field: 'used_at',
        },
        createdAt: {
            type: sequelize_1.DataTypes.DATE,
            field: 'created_at',
        },
        updatedAt: {
            type: sequelize_1.DataTypes.DATE,
            field: 'updated_at',
        },
    }, {
        tableName: 'feedback_tokens',
        timestamps: true,
        indexes: [
            {
                unique: true,
                fields: ['token']
            },
            {
                fields: ['booking_id']
            },
            {
                fields: ['guest_id']
            },
            {
                fields: ['expires_at']
            }
        ]
    });
    // Define associations
    FeedbackToken.associate = (models) => {
        FeedbackToken.belongsTo(models.Booking, { foreignKey: 'bookingId', as: 'booking' });
        FeedbackToken.belongsTo(models.Guest, { foreignKey: 'guestId', as: 'guest' });
    };
    return FeedbackToken;
};
