"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sequelize_1 = require("sequelize");
exports.default = (sequelize) => {
    const Feedback = sequelize.define('Feedback', {
        id: {
            type: sequelize_1.DataTypes.INTEGER,
            autoIncrement: true,
            primaryKey: true,
        },
        bookingId: {
            type: sequelize_1.DataTypes.INTEGER,
            allowNull: false,
            field: 'booking_id',
            references: {
                model: 'bookings',
                key: 'id',
            },
        },
        guestId: {
            type: sequelize_1.DataTypes.INTEGER,
            allowNull: false,
            field: 'guest_id',
            references: {
                model: 'guests',
                key: 'id',
            },
        },
        roomId: {
            type: sequelize_1.DataTypes.INTEGER,
            allowNull: false,
            field: 'room_id',
            references: {
                model: 'rooms',
                key: 'id',
            },
        },
        overallRating: {
            type: sequelize_1.DataTypes.INTEGER,
            allowNull: false,
            field: 'overall_rating',
            validate: {
                min: 1,
                max: 5,
            },
        },
        cleanlinessRating: {
            type: sequelize_1.DataTypes.INTEGER,
            allowNull: true,
            field: 'cleanliness_rating',
            validate: {
                min: 1,
                max: 5,
            },
        },
        serviceRating: {
            type: sequelize_1.DataTypes.INTEGER,
            allowNull: true,
            field: 'service_rating',
            validate: {
                min: 1,
                max: 5,
            },
        },
        locationRating: {
            type: sequelize_1.DataTypes.INTEGER,
            allowNull: true,
            field: 'location_rating',
            validate: {
                min: 1,
                max: 5,
            },
        },
        valueRating: {
            type: sequelize_1.DataTypes.INTEGER,
            allowNull: true,
            field: 'value_rating',
            validate: {
                min: 1,
                max: 5,
            },
        },
        comment: {
            type: sequelize_1.DataTypes.TEXT,
            allowNull: true,
        },
        wouldRecommend: {
            type: sequelize_1.DataTypes.BOOLEAN,
            allowNull: false,
            defaultValue: true,
            field: 'would_recommend',
        },
        isPublished: {
            type: sequelize_1.DataTypes.BOOLEAN,
            allowNull: false,
            defaultValue: true,
            field: 'is_published',
        },
        feedbackToken: {
            type: sequelize_1.DataTypes.STRING(255),
            allowNull: false,
            unique: true,
            field: 'feedback_token',
        },
        submittedAt: {
            type: sequelize_1.DataTypes.DATE,
            allowNull: false,
            defaultValue: sequelize_1.DataTypes.NOW,
            field: 'submitted_at',
        },
        createdAt: {
            type: sequelize_1.DataTypes.DATE,
            field: 'created_at',
        },
        updatedAt: {
            type: sequelize_1.DataTypes.DATE,
            field: 'updated_at',
        },
    }, {
        tableName: 'feedback',
        timestamps: true,
        indexes: [
            {
                fields: ['feedback_token'],
            },
            {
                fields: ['booking_id'],
            },
        ],
    });
    // Define associations
    Feedback.associate = (models) => {
        Feedback.belongsTo(models.Booking, { foreignKey: 'bookingId', as: 'booking' });
        Feedback.belongsTo(models.Guest, { foreignKey: 'guestId', as: 'guest' });
        Feedback.belongsTo(models.Room, { foreignKey: 'roomId', as: 'room' });
    };
    return Feedback;
};
