"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sequelize_1 = require("sequelize");
exports.default = (sequelize) => {
    const ExternalReview = sequelize.define('ExternalReview', {
        id: {
            type: sequelize_1.DataTypes.INTEGER,
            autoIncrement: true,
            primaryKey: true,
        },
        roomId: {
            type: sequelize_1.DataTypes.INTEGER,
            allowNull: false,
            field: 'room_id',
            references: {
                model: 'rooms',
                key: 'id',
            },
        },
        source: {
            type: sequelize_1.DataTypes.STRING(50),
            allowNull: false,
            comment: 'Name of the external platform (Airbnb, Booking.com, etc.)',
        },
        externalId: {
            type: sequelize_1.DataTypes.STRING(100),
            allowNull: false,
            field: 'external_id',
            comment: 'ID of the review on the external platform',
        },
        rating: {
            type: sequelize_1.DataTypes.INTEGER,
            allowNull: false,
            validate: {
                min: 1,
                max: 5,
            },
        },
        comment: {
            type: sequelize_1.DataTypes.TEXT,
            allowNull: false,
        },
        guestName: {
            type: sequelize_1.DataTypes.STRING(100),
            allowNull: false,
            field: 'guest_name',
        },
        guestEmail: {
            type: sequelize_1.DataTypes.STRING(255),
            allowNull: true,
            field: 'guest_email',
        },
        reviewDate: {
            type: sequelize_1.DataTypes.DATE,
            allowNull: false,
            field: 'review_date',
        },
        isPublished: {
            type: sequelize_1.DataTypes.BOOLEAN,
            allowNull: false,
            defaultValue: true,
            field: 'is_published',
        },
        createdAt: {
            type: sequelize_1.DataTypes.DATE,
            field: 'created_at',
        },
        updatedAt: {
            type: sequelize_1.DataTypes.DATE,
            field: 'updated_at',
        },
    }, {
        tableName: 'external_reviews',
        timestamps: true,
        indexes: [
            {
                unique: true,
                fields: ['source', 'external_id'],
            },
            {
                fields: ['room_id'],
            },
            {
                fields: ['source'],
            },
            {
                fields: ['is_published'],
            },
        ],
    });
    // Define associations
    ExternalReview.associate = (models) => {
        ExternalReview.belongsTo(models.Room, { foreignKey: 'roomId', as: 'room' });
    };
    return ExternalReview;
};
