"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sequelize_1 = require("sequelize");
exports.default = (sequelize) => {
    const ExternalCalendar = sequelize.define('ExternalCalendar', {
        id: {
            type: sequelize_1.DataTypes.INTEGER,
            autoIncrement: true,
            primaryKey: true,
        },
        multiRoomCalendarId: {
            type: sequelize_1.DataTypes.INTEGER,
            allowNull: false,
            field: 'multi_room_calendar_id',
            references: {
                model: 'multi_room_calendars',
                key: 'id',
            },
        },
        roomId: {
            type: sequelize_1.DataTypes.INTEGER,
            allowNull: false,
            field: 'room_id',
            references: {
                model: 'rooms',
                key: 'id',
            },
        },
        name: {
            type: sequelize_1.DataTypes.STRING(100),
            allowNull: false,
            comment: 'Descriptive name for this mapping',
        },
        externalRoomIdentifier: {
            type: sequelize_1.DataTypes.STRING(255),
            allowNull: true,
            field: 'external_room_identifier',
            comment: 'External platform room/property ID from ICS',
        },
        mappingRules: {
            type: sequelize_1.DataTypes.JSON,
            allowNull: true,
            field: 'mapping_rules',
            comment: 'Rules for identifying events for this room',
        },
        isActive: {
            type: sequelize_1.DataTypes.BOOLEAN,
            allowNull: false,
            defaultValue: true,
            field: 'is_active',
        },
        createdAt: {
            type: sequelize_1.DataTypes.DATE,
            field: 'created_at',
        },
        updatedAt: {
            type: sequelize_1.DataTypes.DATE,
            field: 'updated_at',
        },
    }, {
        tableName: 'external_calendars',
        timestamps: true,
    });
    // Define associations
    ExternalCalendar.associate = (models) => {
        ExternalCalendar.belongsTo(models.MultiRoomCalendar, { foreignKey: 'multiRoomCalendarId', as: 'multiRoomCalendar' });
        ExternalCalendar.belongsTo(models.Room, { foreignKey: 'roomId', as: 'room' });
    };
    return ExternalCalendar;
};
