"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sequelize_1 = require("sequelize");
exports.default = (sequelize) => {
    const Coupon = sequelize.define('Coupon', {
        id: {
            type: sequelize_1.DataTypes.INTEGER,
            autoIncrement: true,
            primaryKey: true,
        },
        code: {
            type: sequelize_1.DataTypes.STRING,
            allowNull: false,
            unique: true,
        },
        discountPercentage: {
            type: sequelize_1.DataTypes.DECIMAL(5, 2),
            allowNull: false,
            field: 'discount_percentage',
            validate: {
                min: 0,
                max: 100,
            },
        },
        maxDiscount: {
            type: sequelize_1.DataTypes.DECIMAL(10, 2),
            allowNull: false,
            field: 'max_discount',
            validate: {
                min: 0,
            },
        },
        minBookingAmount: {
            type: sequelize_1.DataTypes.DECIMAL(10, 2),
            allowNull: false,
            field: 'min_booking_amount',
            validate: {
                min: 0,
            },
        },
        startDate: {
            type: sequelize_1.DataTypes.DATE,
            allowNull: false,
            field: 'start_date',
        },
        endDate: {
            type: sequelize_1.DataTypes.DATE,
            allowNull: false,
            field: 'end_date',
        },
        isActive: {
            type: sequelize_1.DataTypes.BOOLEAN,
            allowNull: false,
            defaultValue: true,
            field: 'is_active',
        },
        usageLimit: {
            type: sequelize_1.DataTypes.INTEGER,
            allowNull: false,
            field: 'usage_limit',
            validate: {
                min: 0,
            },
        },
        usageCount: {
            type: sequelize_1.DataTypes.INTEGER,
            allowNull: false,
            defaultValue: 0,
            field: 'usage_count',
        },
        createdAt: {
            type: sequelize_1.DataTypes.DATE,
            field: 'created_at',
        },
        updatedAt: {
            type: sequelize_1.DataTypes.DATE,
            field: 'updated_at',
        },
    }, {
        tableName: 'coupons',
        timestamps: true,
        validate: {
            endDateAfterStartDate() {
                if (this.startDate >= this.endDate) {
                    throw new Error('Start date must be before end date');
                }
            },
        },
    });
    // Define associations
    Coupon.associate = (models) => {
        // Add any associations if needed in the future
        // For example, if you want to track which bookings used which coupons:
        // Coupon.hasMany(models.Booking, { foreignKey: 'couponId', as: 'bookings' });
    };
    return Coupon;
};
