"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sequelize_1 = require("sequelize");
exports.default = (sequelize) => {
    const ContactMessage = sequelize.define('ContactMessage', {
        id: {
            type: sequelize_1.DataTypes.INTEGER,
            autoIncrement: true,
            primaryKey: true,
        },
        name: {
            type: sequelize_1.DataTypes.STRING(100),
            allowNull: false,
        },
        email: {
            type: sequelize_1.DataTypes.STRING(100),
            allowNull: false,
            validate: {
                isEmail: true,
            },
        },
        phone: {
            type: sequelize_1.DataTypes.STRING(20),
            allowNull: true,
        },
        subject: {
            type: sequelize_1.DataTypes.STRING(200),
            allowNull: false,
        },
        message: {
            type: sequelize_1.DataTypes.TEXT,
            allowNull: false,
        },
        status: {
            type: sequelize_1.DataTypes.ENUM('new', 'read', 'replied', 'archived'),
            allowNull: false,
            defaultValue: 'new',
        },
        assignedTo: {
            type: sequelize_1.DataTypes.INTEGER,
            allowNull: true,
            field: 'assigned_to',
            references: {
                model: 'users',
                key: 'id',
            },
        },
        replyMessage: {
            type: sequelize_1.DataTypes.TEXT,
            allowNull: true,
            field: 'reply_message',
        },
        repliedAt: {
            type: sequelize_1.DataTypes.DATE,
            allowNull: true,
            field: 'replied_at',
        },
        createdAt: {
            type: sequelize_1.DataTypes.DATE,
            field: 'created_at',
        },
        updatedAt: {
            type: sequelize_1.DataTypes.DATE,
            field: 'updated_at',
        },
    }, {
        tableName: 'contact_messages',
        timestamps: true,
    });
    // Define associations
    ContactMessage.associate = (models) => {
        ContactMessage.belongsTo(models.User, { foreignKey: 'assignedTo', as: 'assignedUser' });
    };
    return ContactMessage;
};
