"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sequelize_1 = require("sequelize");
exports.default = (sequelize) => {
    const BookingAttempt = sequelize.define('BookingAttempt', {
        id: {
            type: sequelize_1.DataTypes.INTEGER,
            autoIncrement: true,
            primaryKey: true,
        },
        ipAddress: {
            type: sequelize_1.DataTypes.STRING(45), // Support both IPv4 and IPv6
            allowNull: false,
            field: 'ip_address',
        },
        isSuccessful: {
            type: sequelize_1.DataTypes.BOOLEAN,
            allowNull: false,
            field: 'is_successful',
        },
        attemptedAt: {
            type: sequelize_1.DataTypes.DATE,
            allowNull: false,
            defaultValue: sequelize_1.DataTypes.NOW,
            field: 'attempted_at',
        },
        bookingId: {
            type: sequelize_1.DataTypes.INTEGER,
            allowNull: true,
            field: 'booking_id',
            references: {
                model: 'bookings',
                key: 'id',
            },
        },
        userAgent: {
            type: sequelize_1.DataTypes.TEXT,
            allowNull: false,
            defaultValue: '',
            field: 'user_agent',
        },
        createdAt: {
            type: sequelize_1.DataTypes.DATE,
            allowNull: false,
            defaultValue: sequelize_1.DataTypes.NOW,
            field: 'created_at',
        },
        updatedAt: {
            type: sequelize_1.DataTypes.DATE,
            allowNull: false,
            defaultValue: sequelize_1.DataTypes.NOW,
            field: 'updated_at',
        },
    }, {
        tableName: 'booking_attempts',
        timestamps: true,
        indexes: [
            {
                fields: ['ip_address'],
            },
            {
                fields: ['attempted_at'],
            },
            {
                fields: ['is_successful'],
            },
            {
                fields: ['booking_id'],
            },
        ],
    });
    // Define associations
    BookingAttempt.associate = (models) => {
        BookingAttempt.belongsTo(models.Booking, {
            foreignKey: 'bookingId',
            as: 'booking',
        });
    };
    return BookingAttempt;
};
