"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const sequelize_1 = require("sequelize");
exports.default = (sequelize) => {
    const Amenity = sequelize.define('Amenity', {
        id: {
            type: sequelize_1.DataTypes.INTEGER,
            autoIncrement: true,
            primaryKey: true,
        },
        name: {
            type: sequelize_1.DataTypes.STRING(100),
            allowNull: false,
        },
        description: {
            type: sequelize_1.DataTypes.TEXT,
            allowNull: false,
        },
        icon: {
            type: sequelize_1.DataTypes.STRING(100),
            allowNull: false,
        },
        createdAt: {
            type: sequelize_1.DataTypes.DATE,
            field: 'created_at',
        },
        updatedAt: {
            type: sequelize_1.DataTypes.DATE,
            field: 'updated_at',
        },
    }, {
        tableName: 'amenities',
        timestamps: true,
    });
    // Define associations
    Amenity.associate = (models) => {
        Amenity.belongsToMany(models.Room, {
            through: 'RoomAmenity',
            foreignKey: 'amenityId',
            otherKey: 'roomId',
            as: 'rooms'
        });
    };
    return Amenity;
};
