"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.validate = void 0;
const zod_1 = require("zod");
const errorHandler_1 = require("../utils/errorHandler");
// Middleware for validating request body, params, and query using Zod schemas
const validate = (schema) => (req, res, next) => {
    try {
        // Validate the request against the provided schema
        schema.parse({
            body: req.body,
            params: req.params,
            query: req.query,
        });
        next();
    }
    catch (error) {
        // Handle Zod validation errors
        if (error instanceof zod_1.ZodError) {
            const errors = error.errors.map((err) => ({
                path: err.path.join('.'),
                message: err.message,
            }));
            next(new errorHandler_1.AppError(`Validation error: ${JSON.stringify(errors)}`, 400));
        }
        else {
            next(error);
        }
    }
};
exports.validate = validate;
