"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.deleteGuest = exports.updateGuest = exports.getGuestById = exports.getAllGuests = exports.createGuest = void 0;
const errorHandler_1 = require("../utils/errorHandler");
const models_1 = __importDefault(require("../models"));
// Create a new guest (public access)
exports.createGuest = (0, errorHandler_1.catchAsync)((req, res) => __awaiter(void 0, void 0, void 0, function* () {
    const { firstName, lastName, email, phone, address, city, state, country, postalCode } = req.body;
    const newGuest = yield models_1.default.Guest.create({
        firstName,
        lastName,
        email,
        phone,
        address,
        city,
        state,
        country,
        postalCode
    });
    res.status(201).json({
        status: 'success',
        data: {
            guest: newGuest
        }
    });
}));
// Get all guests (admin only)
exports.getAllGuests = (0, errorHandler_1.catchAsync)((req, res) => __awaiter(void 0, void 0, void 0, function* () {
    const guests = yield models_1.default.Guest.findAll();
    res.status(200).json({
        status: 'success',
        results: guests.length,
        data: {
            guests
        }
    });
}));
// Get guest by ID (admin only)
exports.getGuestById = (0, errorHandler_1.catchAsync)((req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const guest = yield models_1.default.Guest.findByPk(req.params.id, {
        include: [
            {
                model: models_1.default.Booking,
                as: 'bookings'
            }
        ]
    });
    if (!guest) {
        return next(new errorHandler_1.AppError('No guest found with that ID', 404));
    }
    res.status(200).json({
        status: 'success',
        data: {
            guest
        }
    });
}));
// Update guest information (admin only)
exports.updateGuest = (0, errorHandler_1.catchAsync)((req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const { firstName, lastName, email, phone, address, city, state, country, postalCode } = req.body;
    const guest = yield models_1.default.Guest.findByPk(req.params.id);
    if (!guest) {
        return next(new errorHandler_1.AppError('No guest found with that ID', 404));
    }
    yield guest.update({
        firstName: firstName || guest.firstName,
        lastName: lastName || guest.lastName,
        email: email || guest.email,
        phone: phone || guest.phone,
        address: address || guest.address,
        city: city || guest.city,
        state: state || guest.state,
        country: country || guest.country,
        postalCode: postalCode || guest.postalCode
    });
    res.status(200).json({
        status: 'success',
        data: {
            guest
        }
    });
}));
// Delete guest (admin only)
exports.deleteGuest = (0, errorHandler_1.catchAsync)((req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const guest = yield models_1.default.Guest.findByPk(req.params.id);
    if (!guest) {
        return next(new errorHandler_1.AppError('No guest found with that ID', 404));
    }
    // Check if guest has bookings
    const bookings = yield models_1.default.Booking.findAll({
        where: { guestId: guest.id }
    });
    if (bookings && bookings.length > 0) {
        return next(new errorHandler_1.AppError('Cannot delete guest with existing bookings', 400));
    }
    yield guest.destroy();
    res.status(204).json({
        status: 'success',
        data: null
    });
}));
