"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.applyCoupon = exports.validateCoupon = exports.deleteCoupon = exports.updateCoupon = exports.getCouponById = exports.getAllCoupons = exports.createCoupon = void 0;
const coupon_service_1 = require("../services/coupon.service");
const errorHandler_1 = require("../utils/errorHandler");
exports.createCoupon = (0, errorHandler_1.catchAsync)((req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const coupon = yield coupon_service_1.CouponService.createCoupon(req.body);
    res.status(201).json({
        status: 'success',
        data: {
            coupon
        }
    });
}));
exports.getAllCoupons = (0, errorHandler_1.catchAsync)((req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const coupons = yield coupon_service_1.CouponService.getAllCoupons();
    res.status(200).json({
        status: 'success',
        results: coupons.length,
        data: {
            coupons
        }
    });
}));
exports.getCouponById = (0, errorHandler_1.catchAsync)((req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const coupon = yield coupon_service_1.CouponService.getCouponById(Number(req.params.id));
    if (!coupon) {
        return next(new errorHandler_1.AppError('Coupon not found', 404));
    }
    res.status(200).json({
        status: 'success',
        data: {
            coupon
        }
    });
}));
exports.updateCoupon = (0, errorHandler_1.catchAsync)((req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const coupon = yield coupon_service_1.CouponService.updateCoupon(Number(req.params.id), req.body);
    if (!coupon) {
        return next(new errorHandler_1.AppError('Coupon not found', 404));
    }
    res.status(200).json({
        status: 'success',
        data: {
            coupon
        }
    });
}));
exports.deleteCoupon = (0, errorHandler_1.catchAsync)((req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const success = yield coupon_service_1.CouponService.deleteCoupon(Number(req.params.id));
    if (!success) {
        return next(new errorHandler_1.AppError('Coupon not found', 404));
    }
    res.status(204).json({
        status: 'success',
        data: null
    });
}));
// Landing page specific methods
exports.validateCoupon = (0, errorHandler_1.catchAsync)((req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const { code, bookingAmount } = req.body;
    const validation = yield coupon_service_1.CouponService.validateCoupon(code, bookingAmount);
    if (!validation) {
        return next(new errorHandler_1.AppError('Invalid or expired coupon code', 404));
    }
    const { coupon, discountAmount } = validation;
    res.status(200).json({
        status: 'success',
        data: {
            valid: true,
            discountAmount,
            couponDetails: {
                code: coupon.code,
                discountPercentage: coupon.discountPercentage,
                maxDiscount: coupon.maxDiscount
            }
        }
    });
}));
exports.applyCoupon = (0, errorHandler_1.catchAsync)((req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    const { code, bookingAmount } = req.body;
    const result = yield coupon_service_1.CouponService.applyCoupon(code, bookingAmount);
    res.status(200).json({
        status: 'success',
        data: {
            discountAmount: result.discountAmount,
            finalAmount: result.finalAmount,
            couponDetails: result.couponDetails
        }
    });
}));
