"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCheckoutStatus = exports.getCheckoutFeedbackStats = exports.processCheckoutFeedback = void 0;
const errorHandler_1 = require("../utils/errorHandler");
const checkout_service_1 = __importDefault(require("../services/checkout.service"));
/**
 * Manually trigger checkout feedback processing
 * POST /api/checkout/process-feedback
 */
exports.processCheckoutFeedback = (0, errorHandler_1.catchAsync)((req, res) => __awaiter(void 0, void 0, void 0, function* () {
    // First, ensure all past checkouts are marked as 'completed'
    yield checkout_service_1.default.completePastCheckouts();
    // Then, process the feedback emails for them
    yield checkout_service_1.default.processCheckoutFeedback();
    res.status(200).json({
        status: 'success',
        message: 'Checkout feedback processing completed successfully'
    });
}));
/**
 * Get checkout feedback statistics
 * GET /api/checkout/feedback-stats?days=7
 */
exports.getCheckoutFeedbackStats = (0, errorHandler_1.catchAsync)((req, res) => __awaiter(void 0, void 0, void 0, function* () {
    const days = parseInt(req.query.days) || 7;
    const stats = yield checkout_service_1.default.getCheckoutFeedbackStats(days);
    res.status(200).json({
        status: 'success',
        data: {
            period: `${days} days`,
            stats
        }
    });
}));
/**
 * Get checkout feedback processing status
 * GET /api/checkout/status
 */
exports.getCheckoutStatus = (0, errorHandler_1.catchAsync)((req, res) => __awaiter(void 0, void 0, void 0, function* () {
    // Get today's stats
    const todayStats = yield checkout_service_1.default.getCheckoutFeedbackStats(1);
    // Get weekly stats
    const weeklyStats = yield checkout_service_1.default.getCheckoutFeedbackStats(7);
    res.status(200).json({
        status: 'success',
        data: {
            today: todayStats,
            thisWeek: weeklyStats,
            lastProcessed: new Date().toISOString()
        }
    });
}));
