"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.upsertBookingRules = exports.getBookingRules = void 0;
const models_1 = __importDefault(require("../models"));
const errorHandler_1 = require("../utils/errorHandler");
exports.getBookingRules = (0, errorHandler_1.catchAsync)((req, res) => __awaiter(void 0, void 0, void 0, function* () {
    var _a;
    if ((_a = models_1.default.BookingRule) === null || _a === void 0 ? void 0 : _a.sync) {
        yield models_1.default.BookingRule.sync();
    }
    const rules = yield models_1.default.BookingRule.findAll({ order: [['month', 'ASC']] });
    res.status(200).json({ status: 'success', data: { rules } });
}));
exports.upsertBookingRules = (0, errorHandler_1.catchAsync)((req, res, next) => __awaiter(void 0, void 0, void 0, function* () {
    var _a;
    const body = req.body;
    if (!body || !Array.isArray(body.rules)) {
        return next(new errorHandler_1.AppError('Invalid payload: expected rules array', 400));
    }
    // Validate values
    for (const r of body.rules) {
        if (typeof r.month !== 'number' || r.month < 1 || r.month > 12) {
            return next(new errorHandler_1.AppError(`Invalid month value: ${r.month}`, 400));
        }
        if (typeof r.minNights !== 'number' || r.minNights < 1 || r.minNights > 20) {
            return next(new errorHandler_1.AppError(`Invalid minNights for month ${r.month}. It must be between 1 and 20`, 400));
        }
    }
    // Ensure table exists (create if missing)
    if ((_a = models_1.default.BookingRule) === null || _a === void 0 ? void 0 : _a.sync) {
        yield models_1.default.BookingRule.sync();
    }
    // Upsert 12 months; allow partial updates
    const upserts = body.rules.map((r) => models_1.default.BookingRule.upsert({ month: r.month, minNights: r.minNights }));
    yield Promise.all(upserts);
    const rules = yield models_1.default.BookingRule.findAll({ order: [['month', 'ASC']] });
    res.status(200).json({ status: 'success', data: { rules } });
}));
